#include <amxmodx>
#include <umitem>

#define EspRate	2.5

new PLUGIN_NAME[] 	= "UM Item: ESP"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.0"

new white
new bool:g_ESP[33]
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("ESP", "Expanding circles around enemies", 3200)
	register_event("ResetHUD", "Event_ResetHUD", "be")
	register_event("DeathMsg", "Event_DeathMsg", "a")
}

public plugin_precache() {
	white = precache_model("sprites/white.spr")
}

public client_connect(id) {
	g_ESP[id] = false
}

public Event_DeathMsg() 
{
	if(task_exists(read_data(2))) {
		remove_task(read_data(2))
	}
}

public Event_ResetHUD(id)
{
	if(!is_user_alive(id) || !g_ESP[id]) {
		return PLUGIN_CONTINUE
	}
	if(!task_exists(id)) {
		set_task(EspRate, "esp_loop", id, _, _, "b")
	}
	return PLUGIN_CONTINUE
}

public Enable_Item(id) 
{
	g_ESP[id] = true
	set_task(EspRate, "esp_loop", id, _, _, "b")
}

public Disable_Item(id) 
{
	g_ESP[id] = false
	if(task_exists(id)) {
		remove_task(id)
	}
}

public esp_loop(id)
{	
	if(!is_user_connected(id) || !is_user_alive(id) || !g_ESP[id]) 
	{
		if(task_exists(id)) {
			remove_task(id)
		}
		return PLUGIN_CONTINUE
	}
	
	new iPlayers[32], iNum
	get_players(iPlayers, iNum, "a")
	
	for(new i = 0; i < iNum; ++i)
	{
		new eId = iPlayers[i]
		new aTeam = get_user_team(id)
		new bTeam = get_user_team(eId)
		if(aTeam == bTeam || id == eId) {
			continue
		}

		new iOrigin[3]
		get_user_origin(eId, iOrigin, 0)
			
		message_begin(MSG_ONE, SVC_TEMPENTITY, iOrigin, id)
		write_byte(21)
		write_coord(iOrigin[0])
		write_coord(iOrigin[1])
		write_coord(iOrigin[2] - 35)
		write_coord(iOrigin[0])
		write_coord(iOrigin[1])
		write_coord(iOrigin[2] + 800)
		write_short(white)
		write_byte(0)
		write_byte(1) 
		write_byte(6) 
		write_byte(8)
		write_byte(1) 
		write_byte(100)
		write_byte(100)
		write_byte(255)
		write_byte(192)
		write_byte(0)
		message_end()
	}
	return PLUGIN_CONTINUE
}
	
